/*********************************************************************/
/* Project Name: ADC.mcp                                             */
/* Source fle name: ADC.c                                            */
/*********************************************************************/
/* Copyright (C) 2007 Freescale Semiconductor, Inc.                  */
/* All Rights Reserved                                               */
/*********************************************************************/
/*********************************************************************/
/* Hands on training for QE128 MCU's                                 */
/* Module: ADC                                                       */
/* The firmware was developed and tested on CodeWarrior 6.0 version  */
/*                                                                   */
/* Description: The ADC module is configured in continuous conversion*/
/* mode, every obtained value is display in port E (8-LEDs)          */
/*********************************************************************/
/*                                                                   */
/* Date: 12/03/2007                                                  */
/* Ulises Corrales Salgado                                           */
/* Application Engineer                                              */
/* RTAC Americas                                                     */
/*********************************************************************/                                                                      

#include <hidef.h> /* for EnableInterrupts macro */
#include "derivative.h" /* include peripheral declarations */
typedef unsigned char UINT8;

/*********************************************************************/
/*  Function declarations                                            */
/*********************************************************************/

void MCU_Init(void) {
  
 SOPT1 = 0x23;          /* Watchdog disable. Stop Mode Enable. Background Pin enable. RESET pin enable */  
 SCGC1 = 0x10;          /* Bus Clock to the ADC module is enable */
 SCGC2 = 0x00;          /* Disable Bus clock to unused peripherals */
}

void GPIO_Init(void) { 
  
  PTCDD = (UINT8) (PTCD | 0x3F);          /* Configure PTC0-PTC5 as outputs */
  PTEDD = (UINT8) (PTED | 0xC0);          /* Configure PTE6 and PTE7 pins as outputs */
  PTCD = 0x3F;           /* Put 1's in port C in order to turn off the LEDs */
  PTED = 0xC0;           /* Put 1's in port E port in order to turn off the LEDs */
}

void ADC_configuration (void) {
  
  ADCSC1 = 0x20;        /* Interrupt disable. Continuous conversion mode and channel 0 active */
  ADCSC2 = 0x00;        /* Software trigger selected */
  ADCCFG = 0x30;        /* Input clock/2. Long Sample time configuration. 8-bit conversion */
  APCTL1 = 0x00;        /* ADC0 pin disable, this pin is working as GPIO */
}

/*********************************************************************/
/*  Main Function                                                    */
/*********************************************************************/

void main(void) {

  MCU_Init();       /* Function that initializes the MCU */
  GPIO_Init();      /* Function that initializes the Ports of the MCU */
  ADC_configuration();  /* Function that initializes the ADC module */
  
             
  EnableInterrupts; /* enable interrupts */
  ADCSC1_AIEN = 1;       /* Enable ADC interrupt */
  APCTL1_ADPC0 = 1;      /* Select the channel for ADC input (the pin stop working as GPIO) */
   
  for(;;) {
 
  } /* loop forever */
  /* please make sure that you never leave this function */
}

void interrupt VectorNumber_Vadc ADC_ISR(void) {

 UINT8 temp;                          /* Create a temp variable used for further operations */
 temp = ~ADCRL;                       /* Negate the ADC converted value because is going to be display */
                                      /* on the LEDs (The LEDs turn on with 0's) */
 PTED = (UINT8) (temp & 0xC0);        /* Move the adquired ADC value to port E */
 PTCD = (UINT8) (temp & 0x3F);        /* Move the adquired ADC value to port C */
}

